<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/genomics/v1/variants.proto

namespace Google\Genomics\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A variant set is a collection of call sets and variants. It contains summary
 * statistics of those contents. A variant set belongs to a dataset.
 * For more genomics resource definitions, see [Fundamentals of Google
 * Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
 *
 * Generated from protobuf message <code>google.genomics.v1.VariantSet</code>
 */
class VariantSet extends \Google\Protobuf\Internal\Message
{
    /**
     * The dataset to which this variant set belongs.
     *
     * Generated from protobuf field <code>string dataset_id = 1;</code>
     */
    private $dataset_id = '';
    /**
     * The server-generated variant set ID, unique across all variant sets.
     *
     * Generated from protobuf field <code>string id = 2;</code>
     */
    private $id = '';
    /**
     * The reference set to which the variant set is mapped. The reference set
     * describes the alignment provenance of the variant set, while the
     * `referenceBounds` describe the shape of the actual variant data. The
     * reference set's reference names are a superset of those found in the
     * `referenceBounds`.
     * For example, given a variant set that is mapped to the GRCh38 reference set
     * and contains a single variant on reference 'X', `referenceBounds` would
     * contain only an entry for 'X', while the associated reference set
     * enumerates all possible references: '1', '2', 'X', 'Y', 'MT', etc.
     *
     * Generated from protobuf field <code>string reference_set_id = 6;</code>
     */
    private $reference_set_id = '';
    /**
     * A list of all references used by the variants in a variant set
     * with associated coordinate upper bounds for each one.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1.ReferenceBound reference_bounds = 5;</code>
     */
    private $reference_bounds;
    /**
     * The metadata associated with this variant set.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1.VariantSetMetadata metadata = 4;</code>
     */
    private $metadata;
    /**
     * User-specified, mutable name.
     *
     * Generated from protobuf field <code>string name = 7;</code>
     */
    private $name = '';
    /**
     * A textual description of this variant set.
     *
     * Generated from protobuf field <code>string description = 8;</code>
     */
    private $description = '';

    public function __construct() {
        \GPBMetadata\Google\Genomics\V1\Variants::initOnce();
        parent::__construct();
    }

    /**
     * The dataset to which this variant set belongs.
     *
     * Generated from protobuf field <code>string dataset_id = 1;</code>
     * @return string
     */
    public function getDatasetId()
    {
        return $this->dataset_id;
    }

    /**
     * The dataset to which this variant set belongs.
     *
     * Generated from protobuf field <code>string dataset_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setDatasetId($var)
    {
        GPBUtil::checkString($var, True);
        $this->dataset_id = $var;

        return $this;
    }

    /**
     * The server-generated variant set ID, unique across all variant sets.
     *
     * Generated from protobuf field <code>string id = 2;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * The server-generated variant set ID, unique across all variant sets.
     *
     * Generated from protobuf field <code>string id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * The reference set to which the variant set is mapped. The reference set
     * describes the alignment provenance of the variant set, while the
     * `referenceBounds` describe the shape of the actual variant data. The
     * reference set's reference names are a superset of those found in the
     * `referenceBounds`.
     * For example, given a variant set that is mapped to the GRCh38 reference set
     * and contains a single variant on reference 'X', `referenceBounds` would
     * contain only an entry for 'X', while the associated reference set
     * enumerates all possible references: '1', '2', 'X', 'Y', 'MT', etc.
     *
     * Generated from protobuf field <code>string reference_set_id = 6;</code>
     * @return string
     */
    public function getReferenceSetId()
    {
        return $this->reference_set_id;
    }

    /**
     * The reference set to which the variant set is mapped. The reference set
     * describes the alignment provenance of the variant set, while the
     * `referenceBounds` describe the shape of the actual variant data. The
     * reference set's reference names are a superset of those found in the
     * `referenceBounds`.
     * For example, given a variant set that is mapped to the GRCh38 reference set
     * and contains a single variant on reference 'X', `referenceBounds` would
     * contain only an entry for 'X', while the associated reference set
     * enumerates all possible references: '1', '2', 'X', 'Y', 'MT', etc.
     *
     * Generated from protobuf field <code>string reference_set_id = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setReferenceSetId($var)
    {
        GPBUtil::checkString($var, True);
        $this->reference_set_id = $var;

        return $this;
    }

    /**
     * A list of all references used by the variants in a variant set
     * with associated coordinate upper bounds for each one.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1.ReferenceBound reference_bounds = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReferenceBounds()
    {
        return $this->reference_bounds;
    }

    /**
     * A list of all references used by the variants in a variant set
     * with associated coordinate upper bounds for each one.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1.ReferenceBound reference_bounds = 5;</code>
     * @param \Google\Genomics\V1\ReferenceBound[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReferenceBounds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Genomics\V1\ReferenceBound::class);
        $this->reference_bounds = $arr;

        return $this;
    }

    /**
     * The metadata associated with this variant set.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1.VariantSetMetadata metadata = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    /**
     * The metadata associated with this variant set.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1.VariantSetMetadata metadata = 4;</code>
     * @param \Google\Genomics\V1\VariantSetMetadata[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMetadata($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Genomics\V1\VariantSetMetadata::class);
        $this->metadata = $arr;

        return $this;
    }

    /**
     * User-specified, mutable name.
     *
     * Generated from protobuf field <code>string name = 7;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * User-specified, mutable name.
     *
     * Generated from protobuf field <code>string name = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * A textual description of this variant set.
     *
     * Generated from protobuf field <code>string description = 8;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * A textual description of this variant set.
     *
     * Generated from protobuf field <code>string description = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

}

