<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/genomics/v1/readalignment.proto

namespace Google\Genomics\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A read alignment describes a linear alignment of a string of DNA to a
 * [reference sequence][google.genomics.v1.Reference], in addition to metadata
 * about the fragment (the molecule of DNA sequenced) and the read (the bases
 * which were read by the sequencer). A read is equivalent to a line in a SAM
 * file. A read belongs to exactly one read group and exactly one
 * [read group set][google.genomics.v1.ReadGroupSet].
 * For more genomics resource definitions, see [Fundamentals of Google
 * Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
 * ### Reverse-stranded reads
 * Mapped reads (reads having a non-null `alignment`) can be aligned to either
 * the forward or the reverse strand of their associated reference. Strandedness
 * of a mapped read is encoded by `alignment.position.reverseStrand`.
 * If we consider the reference to be a forward-stranded coordinate space of
 * `[0, reference.length)` with `0` as the left-most position and
 * `reference.length` as the right-most position, reads are always aligned left
 * to right. That is, `alignment.position.position` always refers to the
 * left-most reference coordinate and `alignment.cigar` describes the alignment
 * of this read to the reference from left to right. All per-base fields such as
 * `alignedSequence` and `alignedQuality` share this same left-to-right
 * orientation; this is true of reads which are aligned to either strand. For
 * reverse-stranded reads, this means that `alignedSequence` is the reverse
 * complement of the bases that were originally reported by the sequencing
 * machine.
 * ### Generating a reference-aligned sequence string
 * When interacting with mapped reads, it's often useful to produce a string
 * representing the local alignment of the read to reference. The following
 * pseudocode demonstrates one way of doing this:
 *     out = ""
 *     offset = 0
 *     for c in read.alignment.cigar {
 *       switch c.operation {
 *       case "ALIGNMENT_MATCH", "SEQUENCE_MATCH", "SEQUENCE_MISMATCH":
 *         out += read.alignedSequence[offset:offset+c.operationLength]
 *         offset += c.operationLength
 *         break
 *       case "CLIP_SOFT", "INSERT":
 *         offset += c.operationLength
 *         break
 *       case "PAD":
 *         out += repeat("*", c.operationLength)
 *         break
 *       case "DELETE":
 *         out += repeat("-", c.operationLength)
 *         break
 *       case "SKIP":
 *         out += repeat(" ", c.operationLength)
 *         break
 *       case "CLIP_HARD":
 *         break
 *       }
 *     }
 *     return out
 * ### Converting to SAM's CIGAR string
 * The following pseudocode generates a SAM CIGAR string from the
 * `cigar` field. Note that this is a lossy conversion
 * (`cigar.referenceSequence` is lost).
 *     cigarMap = {
 *       "ALIGNMENT_MATCH": "M",
 *       "INSERT": "I",
 *       "DELETE": "D",
 *       "SKIP": "N",
 *       "CLIP_SOFT": "S",
 *       "CLIP_HARD": "H",
 *       "PAD": "P",
 *       "SEQUENCE_MATCH": "=",
 *       "SEQUENCE_MISMATCH": "X",
 *     }
 *     cigarStr = ""
 *     for c in read.alignment.cigar {
 *       cigarStr += c.operationLength + cigarMap[c.operation]
 *     }
 *     return cigarStr
 *
 * Generated from protobuf message <code>google.genomics.v1.Read</code>
 */
class Read extends \Google\Protobuf\Internal\Message
{
    /**
     * The server-generated read ID, unique across all reads. This is different
     * from the `fragmentName`.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     */
    private $id = '';
    /**
     * The ID of the read group this read belongs to. A read belongs to exactly
     * one read group. This is a server-generated ID which is distinct from SAM's
     * RG tag (for that value, see
     * [ReadGroup.name][google.genomics.v1.ReadGroup.name]).
     *
     * Generated from protobuf field <code>string read_group_id = 2;</code>
     */
    private $read_group_id = '';
    /**
     * The ID of the read group set this read belongs to. A read belongs to
     * exactly one read group set.
     *
     * Generated from protobuf field <code>string read_group_set_id = 3;</code>
     */
    private $read_group_set_id = '';
    /**
     * The fragment name. Equivalent to QNAME (query template name) in SAM.
     *
     * Generated from protobuf field <code>string fragment_name = 4;</code>
     */
    private $fragment_name = '';
    /**
     * The orientation and the distance between reads from the fragment are
     * consistent with the sequencing protocol (SAM flag 0x2).
     *
     * Generated from protobuf field <code>bool proper_placement = 5;</code>
     */
    private $proper_placement = false;
    /**
     * The fragment is a PCR or optical duplicate (SAM flag 0x400).
     *
     * Generated from protobuf field <code>bool duplicate_fragment = 6;</code>
     */
    private $duplicate_fragment = false;
    /**
     * The observed length of the fragment, equivalent to TLEN in SAM.
     *
     * Generated from protobuf field <code>int32 fragment_length = 7;</code>
     */
    private $fragment_length = 0;
    /**
     * The read number in sequencing. 0-based and less than numberReads. This
     * field replaces SAM flag 0x40 and 0x80.
     *
     * Generated from protobuf field <code>int32 read_number = 8;</code>
     */
    private $read_number = 0;
    /**
     * The number of reads in the fragment (extension to SAM flag 0x1).
     *
     * Generated from protobuf field <code>int32 number_reads = 9;</code>
     */
    private $number_reads = 0;
    /**
     * Whether this read did not pass filters, such as platform or vendor quality
     * controls (SAM flag 0x200).
     *
     * Generated from protobuf field <code>bool failed_vendor_quality_checks = 10;</code>
     */
    private $failed_vendor_quality_checks = false;
    /**
     * The linear alignment for this alignment record. This field is null for
     * unmapped reads.
     *
     * Generated from protobuf field <code>.google.genomics.v1.LinearAlignment alignment = 11;</code>
     */
    private $alignment = null;
    /**
     * Whether this alignment is secondary. Equivalent to SAM flag 0x100.
     * A secondary alignment represents an alternative to the primary alignment
     * for this read. Aligners may return secondary alignments if a read can map
     * ambiguously to multiple coordinates in the genome. By convention, each read
     * has one and only one alignment where both `secondaryAlignment`
     * and `supplementaryAlignment` are false.
     *
     * Generated from protobuf field <code>bool secondary_alignment = 12;</code>
     */
    private $secondary_alignment = false;
    /**
     * Whether this alignment is supplementary. Equivalent to SAM flag 0x800.
     * Supplementary alignments are used in the representation of a chimeric
     * alignment. In a chimeric alignment, a read is split into multiple
     * linear alignments that map to different reference contigs. The first
     * linear alignment in the read will be designated as the representative
     * alignment; the remaining linear alignments will be designated as
     * supplementary alignments. These alignments may have different mapping
     * quality scores. In each linear alignment in a chimeric alignment, the read
     * will be hard clipped. The `alignedSequence` and
     * `alignedQuality` fields in the alignment record will only
     * represent the bases for its respective linear alignment.
     *
     * Generated from protobuf field <code>bool supplementary_alignment = 13;</code>
     */
    private $supplementary_alignment = false;
    /**
     * The bases of the read sequence contained in this alignment record,
     * **without CIGAR operations applied** (equivalent to SEQ in SAM).
     * `alignedSequence` and `alignedQuality` may be
     * shorter than the full read sequence and quality. This will occur if the
     * alignment is part of a chimeric alignment, or if the read was trimmed. When
     * this occurs, the CIGAR for this read will begin/end with a hard clip
     * operator that will indicate the length of the excised sequence.
     *
     * Generated from protobuf field <code>string aligned_sequence = 14;</code>
     */
    private $aligned_sequence = '';
    /**
     * The quality of the read sequence contained in this alignment record
     * (equivalent to QUAL in SAM).
     * `alignedSequence` and `alignedQuality` may be shorter than the full read
     * sequence and quality. This will occur if the alignment is part of a
     * chimeric alignment, or if the read was trimmed. When this occurs, the CIGAR
     * for this read will begin/end with a hard clip operator that will indicate
     * the length of the excised sequence.
     *
     * Generated from protobuf field <code>repeated int32 aligned_quality = 15;</code>
     */
    private $aligned_quality;
    /**
     * The mapping of the primary alignment of the
     * `(readNumber+1)%numberReads` read in the fragment. It replaces
     * mate position and mate strand in SAM.
     *
     * Generated from protobuf field <code>.google.genomics.v1.Position next_mate_position = 16;</code>
     */
    private $next_mate_position = null;
    /**
     * A map of additional read alignment information. This must be of the form
     * map<string, string[]> (string key mapping to a list of string values).
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.ListValue> info = 17;</code>
     */
    private $info;

    public function __construct() {
        \GPBMetadata\Google\Genomics\V1\Readalignment::initOnce();
        parent::__construct();
    }

    /**
     * The server-generated read ID, unique across all reads. This is different
     * from the `fragmentName`.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * The server-generated read ID, unique across all reads. This is different
     * from the `fragmentName`.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * The ID of the read group this read belongs to. A read belongs to exactly
     * one read group. This is a server-generated ID which is distinct from SAM's
     * RG tag (for that value, see
     * [ReadGroup.name][google.genomics.v1.ReadGroup.name]).
     *
     * Generated from protobuf field <code>string read_group_id = 2;</code>
     * @return string
     */
    public function getReadGroupId()
    {
        return $this->read_group_id;
    }

    /**
     * The ID of the read group this read belongs to. A read belongs to exactly
     * one read group. This is a server-generated ID which is distinct from SAM's
     * RG tag (for that value, see
     * [ReadGroup.name][google.genomics.v1.ReadGroup.name]).
     *
     * Generated from protobuf field <code>string read_group_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setReadGroupId($var)
    {
        GPBUtil::checkString($var, True);
        $this->read_group_id = $var;

        return $this;
    }

    /**
     * The ID of the read group set this read belongs to. A read belongs to
     * exactly one read group set.
     *
     * Generated from protobuf field <code>string read_group_set_id = 3;</code>
     * @return string
     */
    public function getReadGroupSetId()
    {
        return $this->read_group_set_id;
    }

    /**
     * The ID of the read group set this read belongs to. A read belongs to
     * exactly one read group set.
     *
     * Generated from protobuf field <code>string read_group_set_id = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setReadGroupSetId($var)
    {
        GPBUtil::checkString($var, True);
        $this->read_group_set_id = $var;

        return $this;
    }

    /**
     * The fragment name. Equivalent to QNAME (query template name) in SAM.
     *
     * Generated from protobuf field <code>string fragment_name = 4;</code>
     * @return string
     */
    public function getFragmentName()
    {
        return $this->fragment_name;
    }

    /**
     * The fragment name. Equivalent to QNAME (query template name) in SAM.
     *
     * Generated from protobuf field <code>string fragment_name = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setFragmentName($var)
    {
        GPBUtil::checkString($var, True);
        $this->fragment_name = $var;

        return $this;
    }

    /**
     * The orientation and the distance between reads from the fragment are
     * consistent with the sequencing protocol (SAM flag 0x2).
     *
     * Generated from protobuf field <code>bool proper_placement = 5;</code>
     * @return bool
     */
    public function getProperPlacement()
    {
        return $this->proper_placement;
    }

    /**
     * The orientation and the distance between reads from the fragment are
     * consistent with the sequencing protocol (SAM flag 0x2).
     *
     * Generated from protobuf field <code>bool proper_placement = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setProperPlacement($var)
    {
        GPBUtil::checkBool($var);
        $this->proper_placement = $var;

        return $this;
    }

    /**
     * The fragment is a PCR or optical duplicate (SAM flag 0x400).
     *
     * Generated from protobuf field <code>bool duplicate_fragment = 6;</code>
     * @return bool
     */
    public function getDuplicateFragment()
    {
        return $this->duplicate_fragment;
    }

    /**
     * The fragment is a PCR or optical duplicate (SAM flag 0x400).
     *
     * Generated from protobuf field <code>bool duplicate_fragment = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setDuplicateFragment($var)
    {
        GPBUtil::checkBool($var);
        $this->duplicate_fragment = $var;

        return $this;
    }

    /**
     * The observed length of the fragment, equivalent to TLEN in SAM.
     *
     * Generated from protobuf field <code>int32 fragment_length = 7;</code>
     * @return int
     */
    public function getFragmentLength()
    {
        return $this->fragment_length;
    }

    /**
     * The observed length of the fragment, equivalent to TLEN in SAM.
     *
     * Generated from protobuf field <code>int32 fragment_length = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setFragmentLength($var)
    {
        GPBUtil::checkInt32($var);
        $this->fragment_length = $var;

        return $this;
    }

    /**
     * The read number in sequencing. 0-based and less than numberReads. This
     * field replaces SAM flag 0x40 and 0x80.
     *
     * Generated from protobuf field <code>int32 read_number = 8;</code>
     * @return int
     */
    public function getReadNumber()
    {
        return $this->read_number;
    }

    /**
     * The read number in sequencing. 0-based and less than numberReads. This
     * field replaces SAM flag 0x40 and 0x80.
     *
     * Generated from protobuf field <code>int32 read_number = 8;</code>
     * @param int $var
     * @return $this
     */
    public function setReadNumber($var)
    {
        GPBUtil::checkInt32($var);
        $this->read_number = $var;

        return $this;
    }

    /**
     * The number of reads in the fragment (extension to SAM flag 0x1).
     *
     * Generated from protobuf field <code>int32 number_reads = 9;</code>
     * @return int
     */
    public function getNumberReads()
    {
        return $this->number_reads;
    }

    /**
     * The number of reads in the fragment (extension to SAM flag 0x1).
     *
     * Generated from protobuf field <code>int32 number_reads = 9;</code>
     * @param int $var
     * @return $this
     */
    public function setNumberReads($var)
    {
        GPBUtil::checkInt32($var);
        $this->number_reads = $var;

        return $this;
    }

    /**
     * Whether this read did not pass filters, such as platform or vendor quality
     * controls (SAM flag 0x200).
     *
     * Generated from protobuf field <code>bool failed_vendor_quality_checks = 10;</code>
     * @return bool
     */
    public function getFailedVendorQualityChecks()
    {
        return $this->failed_vendor_quality_checks;
    }

    /**
     * Whether this read did not pass filters, such as platform or vendor quality
     * controls (SAM flag 0x200).
     *
     * Generated from protobuf field <code>bool failed_vendor_quality_checks = 10;</code>
     * @param bool $var
     * @return $this
     */
    public function setFailedVendorQualityChecks($var)
    {
        GPBUtil::checkBool($var);
        $this->failed_vendor_quality_checks = $var;

        return $this;
    }

    /**
     * The linear alignment for this alignment record. This field is null for
     * unmapped reads.
     *
     * Generated from protobuf field <code>.google.genomics.v1.LinearAlignment alignment = 11;</code>
     * @return \Google\Genomics\V1\LinearAlignment
     */
    public function getAlignment()
    {
        return $this->alignment;
    }

    /**
     * The linear alignment for this alignment record. This field is null for
     * unmapped reads.
     *
     * Generated from protobuf field <code>.google.genomics.v1.LinearAlignment alignment = 11;</code>
     * @param \Google\Genomics\V1\LinearAlignment $var
     * @return $this
     */
    public function setAlignment($var)
    {
        GPBUtil::checkMessage($var, \Google\Genomics\V1\LinearAlignment::class);
        $this->alignment = $var;

        return $this;
    }

    /**
     * Whether this alignment is secondary. Equivalent to SAM flag 0x100.
     * A secondary alignment represents an alternative to the primary alignment
     * for this read. Aligners may return secondary alignments if a read can map
     * ambiguously to multiple coordinates in the genome. By convention, each read
     * has one and only one alignment where both `secondaryAlignment`
     * and `supplementaryAlignment` are false.
     *
     * Generated from protobuf field <code>bool secondary_alignment = 12;</code>
     * @return bool
     */
    public function getSecondaryAlignment()
    {
        return $this->secondary_alignment;
    }

    /**
     * Whether this alignment is secondary. Equivalent to SAM flag 0x100.
     * A secondary alignment represents an alternative to the primary alignment
     * for this read. Aligners may return secondary alignments if a read can map
     * ambiguously to multiple coordinates in the genome. By convention, each read
     * has one and only one alignment where both `secondaryAlignment`
     * and `supplementaryAlignment` are false.
     *
     * Generated from protobuf field <code>bool secondary_alignment = 12;</code>
     * @param bool $var
     * @return $this
     */
    public function setSecondaryAlignment($var)
    {
        GPBUtil::checkBool($var);
        $this->secondary_alignment = $var;

        return $this;
    }

    /**
     * Whether this alignment is supplementary. Equivalent to SAM flag 0x800.
     * Supplementary alignments are used in the representation of a chimeric
     * alignment. In a chimeric alignment, a read is split into multiple
     * linear alignments that map to different reference contigs. The first
     * linear alignment in the read will be designated as the representative
     * alignment; the remaining linear alignments will be designated as
     * supplementary alignments. These alignments may have different mapping
     * quality scores. In each linear alignment in a chimeric alignment, the read
     * will be hard clipped. The `alignedSequence` and
     * `alignedQuality` fields in the alignment record will only
     * represent the bases for its respective linear alignment.
     *
     * Generated from protobuf field <code>bool supplementary_alignment = 13;</code>
     * @return bool
     */
    public function getSupplementaryAlignment()
    {
        return $this->supplementary_alignment;
    }

    /**
     * Whether this alignment is supplementary. Equivalent to SAM flag 0x800.
     * Supplementary alignments are used in the representation of a chimeric
     * alignment. In a chimeric alignment, a read is split into multiple
     * linear alignments that map to different reference contigs. The first
     * linear alignment in the read will be designated as the representative
     * alignment; the remaining linear alignments will be designated as
     * supplementary alignments. These alignments may have different mapping
     * quality scores. In each linear alignment in a chimeric alignment, the read
     * will be hard clipped. The `alignedSequence` and
     * `alignedQuality` fields in the alignment record will only
     * represent the bases for its respective linear alignment.
     *
     * Generated from protobuf field <code>bool supplementary_alignment = 13;</code>
     * @param bool $var
     * @return $this
     */
    public function setSupplementaryAlignment($var)
    {
        GPBUtil::checkBool($var);
        $this->supplementary_alignment = $var;

        return $this;
    }

    /**
     * The bases of the read sequence contained in this alignment record,
     * **without CIGAR operations applied** (equivalent to SEQ in SAM).
     * `alignedSequence` and `alignedQuality` may be
     * shorter than the full read sequence and quality. This will occur if the
     * alignment is part of a chimeric alignment, or if the read was trimmed. When
     * this occurs, the CIGAR for this read will begin/end with a hard clip
     * operator that will indicate the length of the excised sequence.
     *
     * Generated from protobuf field <code>string aligned_sequence = 14;</code>
     * @return string
     */
    public function getAlignedSequence()
    {
        return $this->aligned_sequence;
    }

    /**
     * The bases of the read sequence contained in this alignment record,
     * **without CIGAR operations applied** (equivalent to SEQ in SAM).
     * `alignedSequence` and `alignedQuality` may be
     * shorter than the full read sequence and quality. This will occur if the
     * alignment is part of a chimeric alignment, or if the read was trimmed. When
     * this occurs, the CIGAR for this read will begin/end with a hard clip
     * operator that will indicate the length of the excised sequence.
     *
     * Generated from protobuf field <code>string aligned_sequence = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setAlignedSequence($var)
    {
        GPBUtil::checkString($var, True);
        $this->aligned_sequence = $var;

        return $this;
    }

    /**
     * The quality of the read sequence contained in this alignment record
     * (equivalent to QUAL in SAM).
     * `alignedSequence` and `alignedQuality` may be shorter than the full read
     * sequence and quality. This will occur if the alignment is part of a
     * chimeric alignment, or if the read was trimmed. When this occurs, the CIGAR
     * for this read will begin/end with a hard clip operator that will indicate
     * the length of the excised sequence.
     *
     * Generated from protobuf field <code>repeated int32 aligned_quality = 15;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAlignedQuality()
    {
        return $this->aligned_quality;
    }

    /**
     * The quality of the read sequence contained in this alignment record
     * (equivalent to QUAL in SAM).
     * `alignedSequence` and `alignedQuality` may be shorter than the full read
     * sequence and quality. This will occur if the alignment is part of a
     * chimeric alignment, or if the read was trimmed. When this occurs, the CIGAR
     * for this read will begin/end with a hard clip operator that will indicate
     * the length of the excised sequence.
     *
     * Generated from protobuf field <code>repeated int32 aligned_quality = 15;</code>
     * @param int[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAlignedQuality($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::INT32);
        $this->aligned_quality = $arr;

        return $this;
    }

    /**
     * The mapping of the primary alignment of the
     * `(readNumber+1)%numberReads` read in the fragment. It replaces
     * mate position and mate strand in SAM.
     *
     * Generated from protobuf field <code>.google.genomics.v1.Position next_mate_position = 16;</code>
     * @return \Google\Genomics\V1\Position
     */
    public function getNextMatePosition()
    {
        return $this->next_mate_position;
    }

    /**
     * The mapping of the primary alignment of the
     * `(readNumber+1)%numberReads` read in the fragment. It replaces
     * mate position and mate strand in SAM.
     *
     * Generated from protobuf field <code>.google.genomics.v1.Position next_mate_position = 16;</code>
     * @param \Google\Genomics\V1\Position $var
     * @return $this
     */
    public function setNextMatePosition($var)
    {
        GPBUtil::checkMessage($var, \Google\Genomics\V1\Position::class);
        $this->next_mate_position = $var;

        return $this;
    }

    /**
     * A map of additional read alignment information. This must be of the form
     * map<string, string[]> (string key mapping to a list of string values).
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.ListValue> info = 17;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getInfo()
    {
        return $this->info;
    }

    /**
     * A map of additional read alignment information. This must be of the form
     * map<string, string[]> (string key mapping to a list of string values).
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.ListValue> info = 17;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setInfo($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Protobuf\ListValue::class);
        $this->info = $arr;

        return $this;
    }

}

