<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/remoteworkers/v1test2/bots.proto

namespace Google\Devtools\Remoteworkers\V1test2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Lease is a lease that the scheduler has assigned to this bot. If the bot
 * notices (by UpdateBotSession) that it has any leases in the PENDING state, it
 * should call UpdateBotSession to put the leases into the ACTIVE state and
 * start executing their assignments.
 * All fields in this message are output-only, *except* the `state` and `status`
 * fields. Note that repeated fields can only be updated as a unit, so on every
 * update the bot must provide an update for *all* the leases the server expects
 * it to report on.
 * The scheduler *should* ensure that all leases scheduled to a bot can actually
 * be accepted, but race conditions may occur. In such cases, the bot should
 * attempt to accept the leases in the order they are listed by the server, to
 * allow the server to control priorities.
 * The server will remove COMPLETED leases from time to time, after which the
 * bot shouldn't report on them any more (the server will ignore superfluous
 * COMPLETED records).
 *
 * Generated from protobuf message <code>google.devtools.remoteworkers.v1test2.Lease</code>
 */
class Lease extends \Google\Protobuf\Internal\Message
{
    /**
     * The assignment, which is typically a resource that can be accessed through
     * some other services. The assignment must be meaningful to the bot based
     * solely on this name, either because the bot only understands one type of
     * assignment (e.g., tasks served through the Tasks interface) or through some
     * implementation-defined schema.
     * For example, if the worker is executing a Task as defined by the Tasks
     * interface, this field might be projects/{projectid}/tasks/{taskid}.
     * However, it the worker is being assigned pull from a *queue* of tasks, the
     * resource would be the name of the queue, something like
     * projects/{projectid}/locations/{locationid}/queues/{queueid}. That queue
     * may then provide the bot with tasks through another interface, which the
     * bot then processes through the [Tasks]
     * [google.devtools.remoteworkers.v1test2.Tasks] interface.
     * Note that the assignment may be a [full resource name]
     * [https://cloud.google.com/apis/design/resource_names#full_resource_name] if
     * it should be accessed through an endpoint that is not already known to the
     * bot.
     *
     * Generated from protobuf field <code>string assignment = 1;</code>
     */
    private $assignment = '';
    /**
     * The state of the lease. See LeaseState for more information.
     *
     * Generated from protobuf field <code>.google.devtools.remoteworkers.v1test2.LeaseState state = 2;</code>
     */
    private $state = 0;
    /**
     * The final status of the lease (should be populated by the bot if the state
     * is completed). This is the status of the lease, not of any task represented
     * by the lease. For example, if the bot could not accept the lease because it
     * asked for some resource the bot didn't have, this status will be
     * FAILED_PRECONDITION. But if the assignment in the lease didn't execute
     * correctly, this field will be `OK` while the failure of the assignment must
     * be tracked elsewhere (e.g., through the Tasks interface).
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 3;</code>
     */
    private $status = null;
    /**
     * The requirements that are being claimed by this lease. This field may be
     * omitted by the server if the lease is not pending.
     *
     * Generated from protobuf field <code>.google.devtools.remoteworkers.v1test2.Worker requirements = 4;</code>
     */
    private $requirements = null;
    /**
     * The time at which this lease expires. The server *may* extend this over
     * time, but due to race conditions, the bot is not *required* to respect any
     * expiry date except the first one.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 5;</code>
     */
    private $expire_time = null;
    /**
     * While the `assignment` field is a resource name that allows the bot to
     * get the actual assignment, the server can also optionally include the
     * assignment itself inline in order to save a round trip to the server.
     * This doesn't necessarily need to be the resource pointed to by
     * `assignment`. For example, if the assignment is a task, this field could
     * be task.description, not the entire task, since that's all the bot needs
     * to know to get started. As with `assignment` itself, all that's necessary
     * is that the bot knows how to handle the type of message received here.
     * This field may be omitted by the server if the lease is not in the
     * `PENDING` state.
     *
     * Generated from protobuf field <code>.google.protobuf.Any inline_assignment = 6;</code>
     */
    private $inline_assignment = null;

    public function __construct() {
        \GPBMetadata\Google\Devtools\Remoteworkers\V1Test2\Bots::initOnce();
        parent::__construct();
    }

    /**
     * The assignment, which is typically a resource that can be accessed through
     * some other services. The assignment must be meaningful to the bot based
     * solely on this name, either because the bot only understands one type of
     * assignment (e.g., tasks served through the Tasks interface) or through some
     * implementation-defined schema.
     * For example, if the worker is executing a Task as defined by the Tasks
     * interface, this field might be projects/{projectid}/tasks/{taskid}.
     * However, it the worker is being assigned pull from a *queue* of tasks, the
     * resource would be the name of the queue, something like
     * projects/{projectid}/locations/{locationid}/queues/{queueid}. That queue
     * may then provide the bot with tasks through another interface, which the
     * bot then processes through the [Tasks]
     * [google.devtools.remoteworkers.v1test2.Tasks] interface.
     * Note that the assignment may be a [full resource name]
     * [https://cloud.google.com/apis/design/resource_names#full_resource_name] if
     * it should be accessed through an endpoint that is not already known to the
     * bot.
     *
     * Generated from protobuf field <code>string assignment = 1;</code>
     * @return string
     */
    public function getAssignment()
    {
        return $this->assignment;
    }

    /**
     * The assignment, which is typically a resource that can be accessed through
     * some other services. The assignment must be meaningful to the bot based
     * solely on this name, either because the bot only understands one type of
     * assignment (e.g., tasks served through the Tasks interface) or through some
     * implementation-defined schema.
     * For example, if the worker is executing a Task as defined by the Tasks
     * interface, this field might be projects/{projectid}/tasks/{taskid}.
     * However, it the worker is being assigned pull from a *queue* of tasks, the
     * resource would be the name of the queue, something like
     * projects/{projectid}/locations/{locationid}/queues/{queueid}. That queue
     * may then provide the bot with tasks through another interface, which the
     * bot then processes through the [Tasks]
     * [google.devtools.remoteworkers.v1test2.Tasks] interface.
     * Note that the assignment may be a [full resource name]
     * [https://cloud.google.com/apis/design/resource_names#full_resource_name] if
     * it should be accessed through an endpoint that is not already known to the
     * bot.
     *
     * Generated from protobuf field <code>string assignment = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setAssignment($var)
    {
        GPBUtil::checkString($var, True);
        $this->assignment = $var;

        return $this;
    }

    /**
     * The state of the lease. See LeaseState for more information.
     *
     * Generated from protobuf field <code>.google.devtools.remoteworkers.v1test2.LeaseState state = 2;</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * The state of the lease. See LeaseState for more information.
     *
     * Generated from protobuf field <code>.google.devtools.remoteworkers.v1test2.LeaseState state = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Devtools\Remoteworkers\V1test2\LeaseState::class);
        $this->state = $var;

        return $this;
    }

    /**
     * The final status of the lease (should be populated by the bot if the state
     * is completed). This is the status of the lease, not of any task represented
     * by the lease. For example, if the bot could not accept the lease because it
     * asked for some resource the bot didn't have, this status will be
     * FAILED_PRECONDITION. But if the assignment in the lease didn't execute
     * correctly, this field will be `OK` while the failure of the assignment must
     * be tracked elsewhere (e.g., through the Tasks interface).
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 3;</code>
     * @return \Google\Rpc\Status
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * The final status of the lease (should be populated by the bot if the state
     * is completed). This is the status of the lease, not of any task represented
     * by the lease. For example, if the bot could not accept the lease because it
     * asked for some resource the bot didn't have, this status will be
     * FAILED_PRECONDITION. But if the assignment in the lease didn't execute
     * correctly, this field will be `OK` while the failure of the assignment must
     * be tracked elsewhere (e.g., through the Tasks interface).
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 3;</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->status = $var;

        return $this;
    }

    /**
     * The requirements that are being claimed by this lease. This field may be
     * omitted by the server if the lease is not pending.
     *
     * Generated from protobuf field <code>.google.devtools.remoteworkers.v1test2.Worker requirements = 4;</code>
     * @return \Google\Devtools\Remoteworkers\V1test2\Worker
     */
    public function getRequirements()
    {
        return $this->requirements;
    }

    /**
     * The requirements that are being claimed by this lease. This field may be
     * omitted by the server if the lease is not pending.
     *
     * Generated from protobuf field <code>.google.devtools.remoteworkers.v1test2.Worker requirements = 4;</code>
     * @param \Google\Devtools\Remoteworkers\V1test2\Worker $var
     * @return $this
     */
    public function setRequirements($var)
    {
        GPBUtil::checkMessage($var, \Google\Devtools\Remoteworkers\V1test2\Worker::class);
        $this->requirements = $var;

        return $this;
    }

    /**
     * The time at which this lease expires. The server *may* extend this over
     * time, but due to race conditions, the bot is not *required* to respect any
     * expiry date except the first one.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 5;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getExpireTime()
    {
        return $this->expire_time;
    }

    /**
     * The time at which this lease expires. The server *may* extend this over
     * time, but due to race conditions, the bot is not *required* to respect any
     * expiry date except the first one.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 5;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->expire_time = $var;

        return $this;
    }

    /**
     * While the `assignment` field is a resource name that allows the bot to
     * get the actual assignment, the server can also optionally include the
     * assignment itself inline in order to save a round trip to the server.
     * This doesn't necessarily need to be the resource pointed to by
     * `assignment`. For example, if the assignment is a task, this field could
     * be task.description, not the entire task, since that's all the bot needs
     * to know to get started. As with `assignment` itself, all that's necessary
     * is that the bot knows how to handle the type of message received here.
     * This field may be omitted by the server if the lease is not in the
     * `PENDING` state.
     *
     * Generated from protobuf field <code>.google.protobuf.Any inline_assignment = 6;</code>
     * @return \Google\Protobuf\Any
     */
    public function getInlineAssignment()
    {
        return $this->inline_assignment;
    }

    /**
     * While the `assignment` field is a resource name that allows the bot to
     * get the actual assignment, the server can also optionally include the
     * assignment itself inline in order to save a round trip to the server.
     * This doesn't necessarily need to be the resource pointed to by
     * `assignment`. For example, if the assignment is a task, this field could
     * be task.description, not the entire task, since that's all the bot needs
     * to know to get started. As with `assignment` itself, all that's necessary
     * is that the bot knows how to handle the type of message received here.
     * This field may be omitted by the server if the lease is not in the
     * `PENDING` state.
     *
     * Generated from protobuf field <code>.google.protobuf.Any inline_assignment = 6;</code>
     * @param \Google\Protobuf\Any $var
     * @return $this
     */
    public function setInlineAssignment($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Any::class);
        $this->inline_assignment = $var;

        return $this;
    }

}

