<?php
// GENERATED CODE -- DO NOT EDIT!

// Original file comments:
// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
namespace Google\Devtools\Remoteexecution\V1test;

/**
 * The CAS (content-addressable storage) is used to store the inputs to and
 * outputs from the execution service. Each piece of content is addressed by the
 * digest of its binary data.
 *
 * Most of the binary data stored in the CAS is opaque to the execution engine,
 * and is only used as a communication medium. In order to build an
 * [Action][google.devtools.remoteexecution.v1test.Action],
 * however, the client will need to also upload the
 * [Command][google.devtools.remoteexecution.v1test.Command] and input root
 * [Directory][google.devtools.remoteexecution.v1test.Directory] for the Action.
 * The Command and Directory messages must be marshalled to wire format and then
 * uploaded under the hash as with any other piece of content. In practice, the
 * input root directory is likely to refer to other Directories in its
 * hierarchy, which must also each be uploaded on their own.
 *
 * For small file uploads the client should group them together and call
 * [BatchUpdateBlobs][google.devtools.remoteexecution.v1test.ContentAddressableStorage.BatchUpdateBlobs]
 * on chunks of no more than 10 MiB. For large uploads, the client must use the
 * [Write method][google.bytestream.ByteStream.Write] of the ByteStream API. The
 * `resource_name` is `{instance_name}/uploads/{uuid}/blobs/{hash}/{size}`,
 * where `instance_name` is as described in the next paragraph, `uuid` is a
 * version 4 UUID generated by the client, and `hash` and `size` are the
 * [Digest][google.devtools.remoteexecution.v1test.Digest] of the blob. The
 * `uuid` is used only to avoid collisions when multiple clients try to upload
 * the same file (or the same client tries to upload the file multiple times at
 * once on different threads), so the client MAY reuse the `uuid` for uploading
 * different blobs. The `resource_name` may optionally have a trailing filename
 * (or other metadata) for a client to use if it is storing URLs, as in
 * `{instance}/uploads/{uuid}/blobs/{hash}/{size}/foo/bar/baz.cc`. Anything
 * after the `size` is ignored.
 *
 * A single server MAY support multiple instances of the execution system, each
 * with their own workers, storage, cache, etc. The exact relationship between
 * instances is up to the server. If the server does, then the `instance_name`
 * is an identifier, possibly containing multiple path segments, used to
 * distinguish between the various instances on the server, in a manner defined
 * by the server. For servers which do not support multiple instances, then the
 * `instance_name` is the empty path and the leading slash is omitted, so that
 * the `resource_name` becomes `uploads/{uuid}/blobs/{hash}/{size}`.
 *
 * When attempting an upload, if another client has already completed the upload
 * (which may occur in the middle of a single upload if another client uploads
 * the same blob concurrently), the request will terminate immediately with
 * a response whose `committed_size` is the full size of the uploaded file
 * (regardless of how much data was transmitted by the client). If the client
 * completes the upload but the
 * [Digest][google.devtools.remoteexecution.v1test.Digest] does not match, an
 * `INVALID_ARGUMENT` error will be returned. In either case, the client should
 * not attempt to retry the upload.
 *
 * For downloading blobs, the client must use the
 * [Read method][google.bytestream.ByteStream.Read] of the ByteStream API, with
 * a `resource_name` of `"{instance_name}/blobs/{hash}/{size}"`, where
 * `instance_name` is the instance name (see above), and `hash` and `size` are
 * the [Digest][google.devtools.remoteexecution.v1test.Digest] of the blob.
 *
 * The lifetime of entries in the CAS is implementation specific, but it SHOULD
 * be long enough to allow for newly-added and recently looked-up entries to be
 * used in subsequent calls (e.g. to
 * [Execute][google.devtools.remoteexecution.v1test.Execution.Execute]).
 *
 * As with other services in the Remote Execution API, any call may return an
 * error with a [RetryInfo][google.rpc.RetryInfo] error detail providing
 * information about when the client should retry the request; clients SHOULD
 * respect the information provided.
 */
class ContentAddressableStorageClient extends \Grpc\BaseStub {

    /**
     * @param string $hostname hostname
     * @param array $opts channel options
     * @param \Grpc\Channel $channel (optional) re-use channel object
     */
    public function __construct($hostname, $opts, $channel = null) {
        parent::__construct($hostname, $opts, $channel);
    }

    /**
     * Determine if blobs are present in the CAS.
     *
     * Clients can use this API before uploading blobs to determine which ones are
     * already present in the CAS and do not need to be uploaded again.
     *
     * There are no method-specific errors.
     * @param \Google\Devtools\Remoteexecution\V1test\FindMissingBlobsRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     */
    public function FindMissingBlobs(\Google\Devtools\Remoteexecution\V1test\FindMissingBlobsRequest $argument,
      $metadata = [], $options = []) {
        return $this->_simpleRequest('/google.devtools.remoteexecution.v1test.ContentAddressableStorage/FindMissingBlobs',
        $argument,
        ['\Google\Devtools\Remoteexecution\V1test\FindMissingBlobsResponse', 'decode'],
        $metadata, $options);
    }

    /**
     * Upload many blobs at once.
     *
     * The client MUST NOT upload blobs with a combined total size of more than 10
     * MiB using this API. Such requests should either be split into smaller
     * chunks or uploaded using the
     * [ByteStream API][google.bytestream.ByteStream], as appropriate.
     *
     * This request is equivalent to calling [UpdateBlob][] on each individual
     * blob, in parallel. The requests may succeed or fail independently.
     *
     * Errors:
     * * `INVALID_ARGUMENT`: The client attempted to upload more than 10 MiB of
     *   data.
     *
     * Individual requests may return the following errors, additionally:
     * * `RESOURCE_EXHAUSTED`: There is insufficient disk quota to store the blob.
     * * `INVALID_ARGUMENT`: The
     * [Digest][google.devtools.remoteexecution.v1test.Digest] does not match the
     * provided data.
     * @param \Google\Devtools\Remoteexecution\V1test\BatchUpdateBlobsRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     */
    public function BatchUpdateBlobs(\Google\Devtools\Remoteexecution\V1test\BatchUpdateBlobsRequest $argument,
      $metadata = [], $options = []) {
        return $this->_simpleRequest('/google.devtools.remoteexecution.v1test.ContentAddressableStorage/BatchUpdateBlobs',
        $argument,
        ['\Google\Devtools\Remoteexecution\V1test\BatchUpdateBlobsResponse', 'decode'],
        $metadata, $options);
    }

    /**
     * Fetch the entire directory tree rooted at a node.
     *
     * This request must be targeted at a
     * [Directory][google.devtools.remoteexecution.v1test.Directory] stored in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage]
     * (CAS). The server will enumerate the `Directory` tree recursively and
     * return every node descended from the root.
     * The exact traversal order is unspecified and, unless retrieving subsequent
     * pages from an earlier request, is not guaranteed to be stable across
     * multiple invocations of `GetTree`.
     *
     * If part of the tree is missing from the CAS, the server will return the
     * portion present and omit the rest.
     *
     * * `NOT_FOUND`: The requested tree root is not present in the CAS.
     * @param \Google\Devtools\Remoteexecution\V1test\GetTreeRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     */
    public function GetTree(\Google\Devtools\Remoteexecution\V1test\GetTreeRequest $argument,
      $metadata = [], $options = []) {
        return $this->_simpleRequest('/google.devtools.remoteexecution.v1test.ContentAddressableStorage/GetTree',
        $argument,
        ['\Google\Devtools\Remoteexecution\V1test\GetTreeResponse', 'decode'],
        $metadata, $options);
    }

}
