<?php
// GENERATED CODE -- DO NOT EDIT!

// Original file comments:
// Copyright 2016 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
namespace Google\Appengine\V1;

/**
 * Manages versions of a service.
 */
class VersionsClient extends \Grpc\BaseStub {

    /**
     * @param string $hostname hostname
     * @param array $opts channel options
     * @param \Grpc\Channel $channel (optional) re-use channel object
     */
    public function __construct($hostname, $opts, $channel = null) {
        parent::__construct($hostname, $opts, $channel);
    }

    /**
     * Lists the versions of a service.
     * @param \Google\Appengine\V1\ListVersionsRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     */
    public function ListVersions(\Google\Appengine\V1\ListVersionsRequest $argument,
      $metadata = [], $options = []) {
        return $this->_simpleRequest('/google.appengine.v1.Versions/ListVersions',
        $argument,
        ['\Google\Appengine\V1\ListVersionsResponse', 'decode'],
        $metadata, $options);
    }

    /**
     * Gets the specified Version resource.
     * By default, only a `BASIC_VIEW` will be returned.
     * Specify the `FULL_VIEW` parameter to get the full resource.
     * @param \Google\Appengine\V1\GetVersionRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     */
    public function GetVersion(\Google\Appengine\V1\GetVersionRequest $argument,
      $metadata = [], $options = []) {
        return $this->_simpleRequest('/google.appengine.v1.Versions/GetVersion',
        $argument,
        ['\Google\Appengine\V1\Version', 'decode'],
        $metadata, $options);
    }

    /**
     * Deploys code and resource files to a new version.
     * @param \Google\Appengine\V1\CreateVersionRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     */
    public function CreateVersion(\Google\Appengine\V1\CreateVersionRequest $argument,
      $metadata = [], $options = []) {
        return $this->_simpleRequest('/google.appengine.v1.Versions/CreateVersion',
        $argument,
        ['\Google\LongRunning\Operation', 'decode'],
        $metadata, $options);
    }

    /**
     * Updates the specified Version resource.
     * You can specify the following fields depending on the App Engine
     * environment and type of scaling that the version resource uses:
     *
     * * [`serving_status`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.serving_status):
     *   For Version resources that use basic scaling, manual scaling, or run in
     *   the App Engine flexible environment.
     * * [`instance_class`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.instance_class):
     *   For Version resources that run in the App Engine standard environment.
     * * [`automatic_scaling.min_idle_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling):
     *   For Version resources that use automatic scaling and run in the App
     *   Engine standard environment.
     * * [`automatic_scaling.max_idle_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling):
     *   For Version resources that use automatic scaling and run in the App
     *   Engine standard environment.
     * @param \Google\Appengine\V1\UpdateVersionRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     */
    public function UpdateVersion(\Google\Appengine\V1\UpdateVersionRequest $argument,
      $metadata = [], $options = []) {
        return $this->_simpleRequest('/google.appengine.v1.Versions/UpdateVersion',
        $argument,
        ['\Google\LongRunning\Operation', 'decode'],
        $metadata, $options);
    }

    /**
     * Deletes an existing Version resource.
     * @param \Google\Appengine\V1\DeleteVersionRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     */
    public function DeleteVersion(\Google\Appengine\V1\DeleteVersionRequest $argument,
      $metadata = [], $options = []) {
        return $this->_simpleRequest('/google.appengine.v1.Versions/DeleteVersion',
        $argument,
        ['\Google\LongRunning\Operation', 'decode'],
        $metadata, $options);
    }

}
